#NoTrayIcon
#RequireAdmin
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Res_Comment=Diablo 2 IP Finder
#AutoIt3Wrapper_Res_Description=IP Finder
#AutoIt3Wrapper_Res_Fileversion=2.5.0.0
#AutoIt3Wrapper_Res_Language=1033
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#AutoIt3Wrapper_Run_Obfuscator=y
#Obfuscator_Parameters=/striponly
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#cs ----------------------------------------------------------------------------
 AutoIt Version: 3.3.6.1
#ce ----------------------------------------------------------------------------

;;Autoit3 libraries
#include <Date.au3>
#include <GuiConstants.au3>
#include <String.au3>
#include <WindowsConstants.au3>
#include <Sound.au3>

;;Custom functions
#include <NomadMemory.au3>
#include <MinimizedMsg.au3>

Global Const $VersionInfo = 'KissCloneHunter 2.5'

AutoItSetOption("WinDetectHiddenText", 1)
AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

if Not ($CmdLine[$CmdLine[0]] == "launch") Then
	MsgBox(48,$VersionInfo, "This executable is run automatically, please run the regular KCH exe")
	Exit
EndIf

if Not IsAdmin() Then
	MsgBox(48,$VersionInfo,"This program requires admin permissions to run correctly",5)
	Exit
EndIf

GUICreate("KCHClient-" & @AutoItPID,250,100)
GUICtrlCreateLabel("input",10,0,240,30) ;;input controlid: 3
GUICtrlCreateLabel("Startup| | |0/0",10,35,240,30) ;;output control: 4
GUICtrlCreateLabel("",10,70,240,30) ;;log stream control: 5
;~ GUISetState() ;Debug input/output

;; handle to controls in the lobby screen - from R1CH and EoN
Global $OFFSET_D2MULTI_SCREEN = 0x6FA09154
Global $OFFSET_D2MULTI_IPADDRESS_ASCII = 0x6FA2B1F8
Global $OFFSET_D2MULTI_LAST_CHAT_MSG = 0x6FBC3AB0
Global $OFFSET_GAME_PING = 0x6FBC9804
Global $OFFSET_GAMEINFO = 0x48F618
Global $OFFSET_GAMENAME = 0x1B
Global $OFFSET_GAMEPASSWORD = 0x241
Global $OFFSET_D2CLIENT_ScreenSizeX = 0xDBC48
Global $OFFSET_D2CLIENT_ScreenSizeY = 0xDBC4C

Global $MESSAGE_WALKS_ENGLISH = "\ADiablo\sWalks\sthe\sEarth"
Global $MESSAGE_WALKS_GERMAN = "\ADiablo\swandelt\sauf\sder\sErde"
Global $MESSAGE_WALKS_FRENCH = "\ADiablo\smarche\ssur\sle\smonde"
Global $MESSAGE_WALKS_POLISH = "\ADiablo\skroczy\spo\sZiemi"
Global $MESSAGE_WALKS_ITALIAN = "\ADiablo\scammina\ssulla\sTerra"
Global $MESSAGE_WALKS_SPANISH = "\ADiablo\scamina\ssobre\sla\sTierra"
Global $MESSAGE_SOJ_ENGLISH = "\A\d+\sStones\sof\sJordan\sSold\sto\sMerchants"
Global $MESSAGE_SOJ_GERMAN = "\A\d+\sSteine\svon\sJordan\san\sHndler\sverkauft"
Global $MESSAGE_SOJ_FRENCH = "\A\d+\sPierres\sde\sJordan\svendues\saux\smarchands"
Global $MESSAGE_SOJ_POLISH = "\A\d+\s.\sliczba\sKamieni\sjordana\ssprzedanych\skupcom"
Global $MESSAGE_SOJ_ITALIAN = "\A\d+\sPietre\sdi\sJordan\svendute\sai\smercanti"
Global $MESSAGE_SOJ_SPANISH = "\A\d+\sPiedras\sde\sJordan\svendidas\sa\slos\smercaderes"

Global $LOBBY_MAIN_CREATE_X			= 600
Global $LOBBY_MAIN_CREATE_Y			= 463
Global $LOBBY_MAIN_JOIN_X			= 706
Global $LOBBY_MAIN_JOIN_Y			= 463
Global $LOBBY_CREATE_HELL_X			= 706
Global $LOBBY_CREATE_HELL_Y			= 375
Global $LOBBY_CREATE_NORM_X			= 439
Global $LOBBY_CREATE_NORM_Y			= 375
Global $LOBBY_CREATE_X				= 706
Global $LOBBY_CREATE_Y				= 375

Global $changedip = 0
Global $oldptr1, $oldptr2, $oldmsg

Global $startinfo = 0
Global $starthold = 0
Global $successtotal = 0

$DebugForceFind = 0  ;; used for testing only

Global $startdelay = 0
Global $HoldGame = 0
Global $HuntPaused = 0
Global $winprocess = -1
Global $JoinGame = 0
Global $saleopt = 1
Global $heavylog = 0

Global $stopnum, $stoptime, $stopdelay ;Settings
Global $stoptimer, $stoppedtimer ;internal timers
Global $ingametimer

Global $memoryhandle

$UserUniqueGameName = 0
$UserUniqueGamePass = ""
$GameNumber = 0
$GameName = ""
$GamePass = ""
$joinGameName = ""
$joinGamePass = ""
$CurrentIP = 0
$IPList = 0
$FoundSoundFile = @ScriptDir & '\tada.wav'
$DroppedSoundFile = @ScriptDir & '\dropped.mp3'
$WindowName = ""

$MSG_TimeToNextGame = "Time left:"

Dim $HuntedIPs[4] ;; gets redimensioned later, but we need its scope here

$GameDurationSeconds = 180
$AdjustedGameLengthSeconds = 0

;; Note - some users (including the author) experienced, at times,
;; frequent "failed to join game" errors after a new game is created.
;; Increasing the value below might help, but my experience shows
;; that even at 10 seconds, the problem can still occur.
;; If the delay is too small (e.g., 1 second), "failed to join game"
;; errors occur almost every time. There is likely another reason
;; for this error when delay before new game is higher, possibly
;; packet-loss on the local ISP, using a character that was in a game
;; that recently crashed, etc.

$DelayBeforeNewGameSeconds = 5

$AntiIdleDelayMS = 30 * 1000  ;; 30 secs

OnAutoItExitRegister("onexit")
_getwininput()
AdlibRegister("_getwininput",250)

;; must have this priv to read d2's memory
Local $privledge = _SetPrivilege ("SeDebugPrivilege", 1)
if $privledge == 0 Then
	MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to obtain process access rights.",5)
	Exit
EndIf
;; wait until retrieved start info
while $startinfo == 0
	Sleep(100)
WEnd

;open memory handle
$memoryhandle = _MemoryOpen(GetD2ProcessID())
If @error Then
	MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to open memory.",5)
	Exit
EndIf

Local $startdelaynum = 0
while $startdelaynum < $startdelay
	$startdelaynum = $startdelaynum + 1
	_winoutput("Start Delay: " & $startdelay - $startdelaynum & "| | |0/0")
	Sleep(1000)
WEnd
_winoutput("Startup| | |0/0")
if Not ($stoptime == 0) then
	$stoptimer = TimerInit()
endif

;check if we are supposed to hold a game on start instead of hunting
if $starthold == 1 Then HoldStartupGame()

if IsGameActive() Then
	Local $val = MsgBox(3,$VersionInfo & " " & WinGetTitle($WindowName),"Error, already ingame. Continue Hunting?" & @CRLF & "Select 'YES' to exit the game, 'NO' to hold this game, or 'CANCEL' to unload")
	if $val = 2 Then
		Exit ;;cancel
	ElseIf $val = 7 Then ;;no
		getgamenamepass()
		HoldManualGame()
	elseif $val = 6 Then ;;yes
		ExitGame()
		Sleep(5000)
	EndIf
EndIf
VerifyLobbyScreenUp()
_Main()
Exit

Func _Main()
	while (1)

		CreateGame()
		$successtotal = $successtotal + 1
		Sleep(500)

		;; check to see if current game's IP is in list of hunted IPs
		getgamenamepass()
		$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
		If @error Then
			MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
			Exit
		EndIf
		_winoutput("ingame|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
		if $heavylog Then _loginfo("Joined game " & $GameName & "//" & $GamePass & " IP: " & $CurrentIP)

		If IsIPFound($CurrentIP) Then
			AckHuntedIPFound()
		EndIf

		;==============================
		; prepare to wait in the game
		;==============================

		;; calculate the game time in seconds
		$AdjustedGameLengthSeconds = $GameDurationSeconds - $DelayBeforeNewGameSeconds

;~ 		UnPause()
;~ 		GUICtrlSetState($PauseButton, $GUI_ENABLE)

		;; wait in the game, displaying the time remaining and the progress bar
		For $sleepSecond = $AdjustedGameLengthSeconds To 0 Step - 0.5
			_winoutput("ingame; Delay: " & Int($sleepSecond) & "|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

			;;check if ingame and currentip is hunted
			if $changedip = 1 Then
				$changedip = 0
				if IsGameActive() Then
					If IsIPFound($CurrentIP) Then
						AckHuntedIPFound()
					EndIf
				EndIf
			EndIf

			Sleep(500)

			;; if the user pressed the pause button, the variable will be set
			While $HuntPaused = 1
				Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
				_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
				Sleep(500)
			WEnd
			if $JoinGame = 1 Then
				$JoinGame = 0
				_winoutput("Joining Game| | |" & $successtotal & "/" & $GameNumber)
				ExitGame()
				Sleep(5000)
				_joinGame()
			EndIf
			if $HoldGame = 1 Then
				getgamenamepass()
				HoldManualGame()
			EndIf

			;; check for SOJ sales and/or Diablo Walks here,
			;; in case it happens while we're waiting for next game
			;; (that would be bad to ignore it!)
			Local $salemsg = GetLastChatMessage()
			If $salemsg <> "" Then
				Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
				Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
				If $walkval Then
					$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
					If @error Then
						MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
						Exit
					EndIf
					if TimerDiff($ingametimer) > 10000 Then ;wait at least 10 seconds to be sure this isn't the 'Walk' message shown on join
						_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
						_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
						;; only check for messages if user has requested
						If $saleopt == 1 Then InterruptHunt()
					EndIf
				ElseIf $saleval Then
					$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
					If @error Then
						MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
						Exit
					EndIf
					_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & "|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
					if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1))
					;; only check for messages if user has requested
					If $saleopt == 1 Then InterruptHunt()
				EndIf
			EndIf
		Next

		_stopcheck()
		ExitGame()
		For $sleepSecond = $DelayBeforeNewGameSeconds To 0 Step - 0.5
			_winoutput("lobby; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)
			While $HuntPaused = 1
				Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
				_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
				Sleep(500)
			WEnd
			if $JoinGame = 1 Then
				$JoinGame = 0
				_winoutput("Joining Game| | |" & $successtotal & "/" & $GameNumber)
				ExitGame()
				Sleep(3000)
				_joinGame()
			EndIf
			Sleep(500)
		Next

	WEnd
EndFunc

; ===========================================

Func getgamenamepass()
	$GameinfoStart = _ProcessGetLoadedModules(GetD2ProcessID(),"d2client.dll")
	$Gameinfo = _MemoryRead($GameinfoStart + $OFFSET_GAMEINFO, $memoryhandle, 'dword')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf
	$GameinfoName = $Gameinfo + $OFFSET_GAMENAME
	$GameinfoPass = $Gameinfo + $OFFSET_GAMEPASSWORD
	$GameName = _MemoryRead($GameinfoName, $memoryhandle, 'char[24]')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf
	$GamePass = _MemoryRead($GameinfoPass, $memoryhandle, 'char[24]')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf
EndFunc

; ===========================================

Func ChangeDelay()
	Do
        $value = InputBox($VersionInfo & ": Game duration", "Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.", $GameDurationSeconds, " M","","","","",30)
		if @error = 1 Then
			Return
		EndIf
    Until (($value >= 10) AND (StringIsInt($value)))
	$GameDurationSeconds = $value
;~ 	GUICtrlSetData($GameDurationLabel, $GameDurationSeconds & " seconds")
EndFunc

; ========================================

Func CreateGame()
	VerifyLobbyScreenUp()
    Do
		;; click "Join" button (to make sure "Create" will be active; it can be grayed out after create fails)
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)
		;; click "Create" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_CREATE_X, $LOBBY_MAIN_CREATE_Y,1,1)
		Sleep(400)
        ;; click Hell level button
        _MouseClickMinimized($WindowName, "left", $LOBBY_CREATE_X, $LOBBY_CREATE_Y,1,1)
		Sleep(400)

        ;; make game name and password
        $GameNumber = $GameNumber + 1
        $GameName = $UserUniqueGameName & $GameNumber
		if $UserUniqueGamePass = "" Then
			$GamePass = $GameNumber
		Else
			$GamePass = $UserUniqueGamePass
		EndIf

		_winoutput("Creating Game: " & $GameNumber & "| | |" & $successtotal & "/" & $GameNumber)

		_SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

    Until IsGameCreated() = 1

	$ingametimer = TimerInit()

    Return

EndFunc   ;==>CreateGame

; ========================================

;; logic is a bit strange here...

Func IsGameCreated()

    ; init a timer, so we can see how long this takes (for recovery)
    $TimerStart = TimerInit()

    Local $RetryCount = 0
    Do
        If IsLobbyScreenUp() Then ;; wait until we leave the game lobby
			Sleep(1000)
		Else
			ExitLoop
		EndIf
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 15

    $RetryCount = 0
    Do
        If IsGameActive() Then
            Return 1
        EndIf
		If IsLobbyScreenUp() Then ExitLoop ;; returned to lobby (ftj)
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 60


    ; Assume now that Game creation has failed and try to recover
    ; we only deal with "failed to join game" errors, so we assume that happened.
    ; All we can do is wait the gameduration or 40 seconds (so the screen goes away), because a game was created that we couldn't join
    if $GameDurationSeconds < 40 Then
		$InitSecondsRemaining = (40 - Int(TimerDiff($TimerStart) / 1000))
	Else
		$InitSecondsRemaining = ($GameDurationSeconds - Int(TimerDiff($TimerStart) / 1000))
	EndIf
	if $heavylog Then _loginfo("Failed to join game, waiting " & $InitSecondsRemaining & " seconds")
;~ 	GUICtrlSetState($PauseButton, $GUI_ENABLE)
    For $sleepSecond = $InitSecondsRemaining To 0 Step - 0.5
        $percentComplete = Int(100 * ($InitSecondsRemaining - $sleepSecond) / $InitSecondsRemaining)
        _winoutput("FTJ; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)

		While $HuntPaused = 1
			Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
			_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
			Sleep(500)
		WEnd

		if $JoinGame = 1 Then
			$JoinGame = 0
			_winoutput("Joining Game| | |" & $successtotal & "/" & $GameNumber)
			ExitGame()
			Sleep(3000)
			_joinGame()
		EndIf
		if $HoldGame = 1 Then
			getgamenamepass()
			HoldManualGame()
		EndIf

        Sleep(500)

    Next

	_stopcheck()

    VerifyLobbyScreenUp()

    Return 0

EndFunc   ;==>IsGameCreated

; ========================================

Func IsLobbyScreenUp()

	$Value = _MemoryRead ($OFFSET_D2MULTI_SCREEN, $memoryhandle, 'dword')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf

    If $Value <> 0 Then
        Return 1
    Else
        Return 0
    EndIf

EndFunc   ;==>IsLobbyScreenUp

; ========================================

Func VerifyLobbyScreenUp()

	;; wait to join lobby
	Local $retries = 0
	While ((Not IsLobbyScreenUp()) And $retries < 20)
		Sleep(500)
		$retries = $retries + 1
	WEnd

    If Not IsLobbyScreenUp() Then
        Do
            $userResponse = MsgBox(5 + 32 + 262144, $VersionInfo & ": Problem" & " " & WinGetTitle($WindowName), "Either the Lobby Screen is not active in the Diablo II window, or the Create button is grayed out and I cannot create a game." & @CRLF & "Please make sure you've opened a character in Diablo and are waiting in the lobby screen, with the Create button present and enabled.")
            If $userResponse = 2 Then
                ;; user chose to cancel, exit...
                Exit
            EndIf
        Until IsLobbyScreenUp()
    Else
;~ 		GUICtrlSetState($HoldAbandonButton,$GUI_ENABLE)
        ;; everything is good, continue on
    EndIf

EndFunc   ;==>VerifyLobbyScreenUp

; ========================================

Func GetD2ProcessID()
	$ProcID = $winprocess
    If $ProcID = -1 Then
        MsgBox(16, "ERROR" & " " & WinGetTitle($WindowName), "Diablo Game appears not to be running. Exiting...")
        Exit
    EndIf
    Return $ProcID
EndFunc   ;==>GetD2ProcessID

; ========================================

Func IsGameActive()

    ;; if game is active, then the game ping will be > 0

    $ping = ReadGamePing()
    If $ping > 0 Then
        Return 1
    Else
        Return 0
    EndIf

EndFunc   ;==>IsGameActive

; ========================================

Func ReadGamePing()

    Local $Value

    Local $ProcessID = GetD2ProcessID()
	$value = _MemoryRead($OFFSET_GAME_PING, $memoryhandle, 'dword')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf

	Return $Value

EndFunc   ;==>ReadGamePing

; ========================================

Func IsIPFound($IP)
    ;; find last "." in IP address
    $lastDot = StringInStr($IP, ".", 0, 3)
    ;; find last part of IP address
    $lastPart = StringMid($IP, $lastDot + 1)

    ;; search for last part of IP in the HuntedIP array
    If $DebugForceFind Then
        $HuntedIPIsFound = 1
    Else
        $HuntedIPIsFound = 0
    EndIf

    For $r = 0 To UBound($HuntedIPs) - 1
        ;; MsgBox(4096, 'Comparing', "Comparing '" & $HuntedIPs[$r] & "' to '" & $lastPart & "'")
        If $HuntedIPs[$r] = $lastPart Then $HuntedIPIsFound = 1
    Next
    Return $HuntedIPIsFound
EndFunc   ;==>IsIPFound

; ========================================

Func _stopcheck()
	;Check if stop/pause after X Games
	if Not ($stopnum == 0) Then
;~ 		MsgBox(0,"stopdelay: " & $stopdelay,$gamenumber & @CRLF & $stopnum & @CRLF & Int($gamenumber/$stopnum) & @CRLF & ($gamenumber/$stopnum))
		if Int($gamenumber/$stopnum) == ($gamenumber/$stopnum) then
			if $stopdelay == -1 then
				ExitGame()
				sleep(1000)
				if $heavylog Then _loginfo("Stopped after " & $stopnum & " games.")
				$HuntPaused = 1
				While $HuntPaused == 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Return
			else
				$stoppedtimer = TimerInit()
				if $heavylog Then _loginfo("Paused for " & $stopdelay & " seconds.")
				local $ai = 0
				while TimerDiff($stoppedtimer) < $stopdelay
					$ai = $ai + 1
					;only do anti-idle every 30 seconds
					if $ai >= 30 Then
						$ai = 0
						AntiIdle()
					EndIf
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					if int(($stopdelay-TimerDiff($stoppedtimer))/1000/60) == 0 Then
						_winoutput("Wait: " & int(($stopdelay-TimerDiff($stoppedtimer))/1000) & "s" & StringMid($prev,StringInStr($prev,"|")))
					Else
						_winoutput("Wait: " & int(($stopdelay-TimerDiff($stoppedtimer))/1000/60) & "m" & StringMid($prev,StringInStr($prev,"|")))
					EndIf
					;; check for join game command
					if $JoinGame = 1 Then
						$JoinGame = 0
						_winoutput("Joining Game| | |" & $successtotal & "/" & $GameNumber)
						ExitGame()
						Sleep(5000)
						_joinGame()
					EndIf

					Local $salemsg = GetLastChatMessage()
					If $salemsg <> "" Then
						Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
						Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
						If $walkval Then
							$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
							If @error Then
								MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
								Exit
							EndIf
							_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
							if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
							;; only check for messages if user has requested
							If $saleopt == 1 Then InterruptHunt()
						ElseIf $saleval Then
							$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
							If @error Then
								MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
								Exit
							EndIf
							_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & "|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
							if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1))
							;; only check for messages if user has requested
							If $saleopt == 1 Then InterruptHunt()
						EndIf
					EndIf

					While $HuntPaused = 1
						Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
						_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))

						;; check for join game command
						if $JoinGame = 1 Then
							$JoinGame = 0
							_winoutput("Joining Game| | |" & $successtotal & "/" & $GameNumber)
							ExitGame()
							Sleep(5000)
							_joinGame()
						EndIf

						Local $salemsg = GetLastChatMessage()
						If $salemsg <> "" Then
							Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
							Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
							If $walkval Then
								$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
								If @error Then
									MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
									Exit
								EndIf
								_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
								if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
								;; only check for messages if user has requested
								If $saleopt == 1 Then InterruptHunt()
							ElseIf $saleval Then
								$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
								If @error Then
									MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
									Exit
								EndIf
								_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & "|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
								if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1))
								;; only check for messages if user has requested
								If $saleopt == 1 Then InterruptHunt()
							EndIf
						EndIf
						Sleep(500)
					WEnd
					sleep(500)
				wend
			endif
		Endif
	endif
	;Check if stop/pause after X Time
	if Not ($stoptime == 0) Then
		if TimerDiff($stoptimer) >= $stoptime then
			if $stopdelay == -1 then
				ExitGame()
				sleep(1000)
				if $heavylog Then _loginfo("Stopped after " & $stoptime & " seconds.")
				$HuntPaused = 1
				While $HuntPaused = 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Return
			else
				$stoppedtimer = TimerInit()
				if $heavylog Then _loginfo("Paused for  " & $stopdelay & " seconds.")
				local $ai = 0
				while TimerDiff($stoppedtimer) < $stopdelay
					$ai = $ai + 1
					;only do anti-idle every 30 seconds
					if $ai >= 30 Then
						$ai = 0
						AntiIdle()
					EndIf
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					if int(($stopdelay-TimerDiff($stoppedtimer))/1000/60) == 0 Then
						_winoutput("Wait: " & int(($stopdelay-TimerDiff($stoppedtimer))/1000) & "s" & StringMid($prev,StringInStr($prev,"|")))
					Else
						_winoutput("Wait: " & int(($stopdelay-TimerDiff($stoppedtimer))/1000/60) & "m" & StringMid($prev,StringInStr($prev,"|")))
					EndIf
					While $HuntPaused = 1
						Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
						_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
						Local $salemsg = GetLastChatMessage()
						If $salemsg <> "" Then
							Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
							Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
							If $walkval Then
								$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
								If @error Then
									MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
									Exit
								EndIf
								_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
								if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
								;; only check for messages if user has requested
								If $saleopt == 1 Then InterruptHunt()
							ElseIf $saleval Then
								$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
								If @error Then
									MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
									Exit
								EndIf
								_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & "|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
								if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1))
								;; only check for messages if user has requested
								If $saleopt == 1 Then InterruptHunt()
							EndIf
						EndIf
						Sleep(500)
					WEnd
					sleep(500)
				wend
			endif
			$stoptimer = TimerInit()
		Endif
	endif
EndFunc

; ========================================

Func ExitGame()
    $HoldGame = 0

    ;; only try to exit if a game's not active

    If IsGameActive() Then
        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
		_SendMinimized($WindowName, '{UP}')
		Sleep(100)
		_SendMinimized($WindowName, '{ENTER}')

        ;; wait to disconnect from game
		Local $retries = 0
		While (IsGameActive() And $retries < 20)
			Sleep(500)
			$retries = $retries + 1
		WEnd
		if (Not IsGameActive()) Then
			;; wait to join lobby
			While ((Not IsLobbyScreenUp()) And $retries < 20)
				Sleep(500)
				$retries = $retries + 1
			WEnd
		EndIf

    Else
;~         AppendLineToLogText( "Game is already inactive; attempting to continue without exiting.")
    EndIf
	If IsGameActive() Then
;~ 		AppendLineToLogText( "Failed to exit game. trying alternate method")
		Local $coordx = 439
		Local $coordy = 259
		Local $d2clientdll = _ProcessGetLoadedModules(GetD2ProcessID(),"d2client.dll")
		Local $sizex = _MemoryRead($d2clientdll + $OFFSET_D2CLIENT_ScreenSizeX, $memoryhandle, 'dword')
		Local $sizey = _MemoryRead($d2clientdll + $OFFSET_D2CLIENT_ScreenSizeY, $memoryhandle, 'dword')
		If (($sizex == 640) And ($sizey == 480)) Then ;support for 640x480 clients
			$coordx = 320
			$coordy = 200
		EndIf
		_SendMinimized($WindowName, "{SPACE}{SPACE}")
        Sleep(100)

        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
        _MouseClickMinimized($WindowName, "left", $coordx, $coordy,1,1)  ;; coordinates of "Save and Exit Game"
		Sleep(500)
		_MouseClickMinimized($WindowName, "left", $coordx, $coordy,1,1)  ;; coordinates of "Save and Exit Game"

        ;; wait to disconnect from game
		Local $retries = 0
		While (IsGameActive() And $retries < 20)
			Sleep(500)
			$retries = $retries + 1
		WEnd
		if (Not IsGameActive()) Then
			;; wait to join lobby
			While ((Not IsLobbyScreenUp()) And $retries < 20)
				Sleep(500)
				$retries = $retries + 1
			WEnd
		EndIf
	EndIf

    VerifyLobbyScreenUp()
    Return

EndFunc   ;==>ExitGame

; ========================================

Func AckHuntedIPFound()
    $HoldGame = 1

	$ingametimer = TimerInit()
	getgamenamepass()
	_loginfo("Found: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
	_winoutput("Found Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

    ;; Give the user a chance to acknowledge the game has been found, NOT repeating the sound
	Local $sound = _SoundOpen($FoundSoundFile)
	_SoundPlay($sound)
;~ 	TrayTip("Success!!!", "Hunted IP " & $CurrentIP & " has been found!!!" & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while IsGameActive()
		if $HoldGame = 0 Then
			_winoutput("Leaving Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
			ExitGame()
			For $sleepSecond = $DelayBeforeNewGameSeconds To 0 Step - 0.5
				_winoutput("lobby; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)
				While $HuntPaused = 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Sleep(500)
			Next
			VerifyLobbyScreenUp()
			_Main()
		EndIf

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
			Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
			If $walkval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				if TimerDiff($ingametimer) > 10000 Then ;wait at least 10 seconds to be sure this isn't the 'Walk' message shown on join
					_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
					_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
				EndIf
			ElseIf $saleval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & " |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1))
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)

	;; Give the user a chance to acknowledge the game has been dropped
	Local $sound = _SoundOpen($DroppedSoundFile)
	_SoundPlay($sound)

    RejoinLostGameIP()

    Return

EndFunc   ;==>AckHuntedIPFound

; ========================================

Func RejoinLostGameIP()
        ;; wait to disconnect from game
		Local $retries = 0
		While (IsGameActive() And $retries < 20)
			Sleep(500)
			$retries = $retries + 1
		WEnd
		;; wait for 'connection interrupted' to go away
		$retries = 0
		While ((Not IsLobbyScreenUp()) And $retries < 120)
			Sleep(500)
			$retries = $retries + 1
		WEnd

		Sleep(5000) ;;give the servers a few seconds so we dont instantly fail-to-join

		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)


;~         AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
		_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
		_winoutput("Rejoining Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

        $RetryCount = 0
    Do
        If IsGameActive() Then
;~ 			AppendLineToLogText( "Successfilly rejoined game!")
            AckHuntedIPFound()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

;~ 	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	if $heavylog Then _loginfo("Failed to rejoin game; Continuing hunting")
	_winoutput("Hunting again| | |" & $successtotal & "/" & $GameNumber)
	$HoldGame = 0
;~     GUICtrlSetData($HoldAbandonButton, "Hold Game")
;~ 	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_Main()

EndFunc

; ========================================

Func InterruptHunt()
    $HoldGame = 1

	$ingametimer = TimerInit()
	getgamenamepass()
	_loginfo("Sells: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
	_winoutput("Detected Sells|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

    ;; Give the user a chance to acknowledge the game is being held, NOT repeating the sound
    Local $sound = _SoundOpen($FoundSoundFile)
	_SoundPlay($sound)
;~ 	TrayTip("Possible success!!!", "Chat messages indicate activity on " & $CurrentIP & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while IsGameActive()
		if $HoldGame = 0 Then
			_winoutput("Leaving Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
			ExitGame()
			For $sleepSecond = $DelayBeforeNewGameSeconds To 0 Step - 0.5
				_winoutput("lobby; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)
				While $HuntPaused = 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Sleep(500)
			Next
			VerifyLobbyScreenUp()
			_Main()
		EndIf

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
			Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
			If $walkval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				if TimerDiff($ingametimer) > 10000 Then ;wait at least 10 seconds to be sure this isn't the 'Walk' message shown on join
					_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
					_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
				EndIf
			ElseIf $saleval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & " |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1))
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)

	;; Give the user a chance to acknowledge the game has been dropped
	Local $sound = _SoundOpen($DroppedSoundFile)
	_SoundPlay($sound)

    RejoinLostGameInt()

    Return

EndFunc   ;==>InterruptHunt

; ============================================

Func RejoinLostGameInt()

        ;; wait to disconnect from game
		Local $retries = 0
		While (IsGameActive() And $retries < 20)
			Sleep(500)
			$retries = $retries + 1
		WEnd
		;; wait for 'connection interrupted' to go away
		$retries = 0
		While ((Not IsLobbyScreenUp()) And $retries < 120)
			Sleep(500)
			$retries = $retries + 1
		WEnd

		Sleep(5000) ;;give the servers a few seconds so we dont instantly fail-to-join

		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)

;~         AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
		_loginfo("Rejoining game: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
		_winoutput("Rejoining Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

        $RetryCount = 0
    Do
        If IsGameActive() Then
;~ 			AppendLineToLogText( "Successfilly rejoined game!")
            InterruptHunt()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

;~ 	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
;~ 	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	if $heavylog Then _loginfo("Failed to rejoin game; Continuing hunting")
	_winoutput("Hunting again| | |" & $successtotal & "/" & $GameNumber)
	$HoldGame = 0
;~     GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()

EndFunc

; ========================================

Func HoldManualGame()
    $HoldGame = 1

	$ingametimer = TimerInit()
	getgamenamepass()
	$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf
	_loginfo("Holding game: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
	_winoutput("Held Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)


    ;; Give the user a chance to acknowledge the game is being held, no sound
    $ai = 0
	while IsGameActive()
		if $HoldGame = 0 Then
			_winoutput("Leaving Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
			ExitGame()
			For $sleepSecond = $DelayBeforeNewGameSeconds To 0 Step - 0.5
				_winoutput("lobby; Delay: " & Int($sleepSecond) & "| | |" & $successtotal & "/" & $GameNumber)
				While $HuntPaused = 1
					Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
					_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
					Sleep(500)
				WEnd
				Sleep(500)
			Next
			VerifyLobbyScreenUp()
			_Main()
		EndIf

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
			Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
			If $walkval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				if TimerDiff($ingametimer) > 10000 Then ;wait at least 10 seconds to be sure this isn't the 'Walk' message shown on join
					_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
					_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
				EndIf
			ElseIf $saleval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & " |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1))
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()

		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)

	;; Give the user a chance to acknowledge the game has been dropped
	Local $sound = _SoundOpen($DroppedSoundFile)
	_SoundPlay($sound)

    RejoinLostGameHold()

    Return

EndFunc

; ============================================

Func RejoinLostGameHold()

		;; wait to disconnect from game
		Local $retries = 0
		While (IsGameActive() And $retries < 20)
			Sleep(500)
			$retries = $retries + 1
		WEnd
		;; wait for 'connection interrupted' to go away
		$retries = 0
		While ((Not IsLobbyScreenUp()) And $retries < 120)
			Sleep(500)
			$retries = $retries + 1
		WEnd

		Sleep(5000) ;;give the servers a few seconds so we dont instantly fail-to-join

		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)


;~         AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
		_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
		_winoutput("Rejoining Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)

        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

        $RetryCount = 0
    Do
        If IsGameActive() Then
            HoldManualGame()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

;~ 	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
;~ 	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	if $heavylog Then _loginfo("Failed to rejoin game; Continuing hunting")
	_winoutput("Hunting again| | |" & $successtotal & "/" & $GameNumber)
	$HoldGame = 0
;~     GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()

EndFunc

Func HoldStartupGame()
	if Not IsGameActive() Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Not currently in a game.",5)
		Exit
	EndIf
    $HoldGame = 1

	$ingametimer = TimerInit()
	getgamenamepass()
	$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
	If @error Then
		MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
		Exit
	EndIf
	_loginfo("Holding game: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
	_winoutput("Held Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)


    ;; Give the user a chance to acknowledge the game is being held, no sound
    $ai = 0
	while IsGameActive()

		;; check for SOJ sales and/or Diablo Walks here and display them
		Local $salemsg = GetLastChatMessage()
		If $salemsg <> "" Then
			Local $walkval = BitOR(StringRegExp($salemsg,$MESSAGE_WALKS_ENGLISH),StringRegExp($salemsg,$MESSAGE_WALKS_GERMAN),StringRegExp($salemsg,$MESSAGE_WALKS_FRENCH),StringRegExp($salemsg,$MESSAGE_WALKS_POLISH),StringRegExp($salemsg,$MESSAGE_WALKS_ITALIAN),StringRegExp($salemsg,$MESSAGE_WALKS_SPANISH))
			Local $saleval = BitOR(StringRegExp($salemsg,$MESSAGE_SOJ_ENGLISH),StringRegExp($salemsg,$MESSAGE_SOJ_GERMAN),StringRegExp($salemsg,$MESSAGE_SOJ_FRENCH),StringRegExp($salemsg,$MESSAGE_SOJ_POLISH),StringRegExp($salemsg,$MESSAGE_SOJ_ITALIAN),StringRegExp($salemsg,$MESSAGE_SOJ_SPANISH))
			If $walkval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				if TimerDiff($ingametimer) > 10000 Then ;wait at least 10 seconds to be sure this isn't the 'Walk' message shown on join
					_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
					_loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@WALK")
				EndIf
			ElseIf $saleval Then
				$CurrentIP = _MemoryRead($OFFSET_D2MULTI_IPADDRESS_ASCII, $memoryhandle, 'char[16]')
				If @error Then
					MsgBox(16, "ERROR " & WinGetTitle($WindowName), "Failed to read memory.",5)
					Exit
				EndIf
				_winoutput(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1) & " |" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
				if TimerDiff($ingametimer) > 10000 Then _loginfo(StringReplace(StringRight($CurrentIP,3),".","") & "@" & StringLeft($salemsg,StringInStr($salemsg," ")-1))
			EndIf
		EndIf

		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()

		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)

	;; Give the user a chance to acknowledge the game has been dropped
	Local $sound = _SoundOpen($DroppedSoundFile)
	_SoundPlay($sound)

    RejoinLostGameStartup()

    Return

EndFunc

; ============================================

Func RejoinLostGameStartup()

		;; wait to disconnect from game
		Local $retries = 0
		While (IsGameActive() And $retries < 20)
			Sleep(500)
			$retries = $retries + 1
		WEnd
		;; wait for 'connection interrupted' to go away
		$retries = 0
		While ((Not IsLobbyScreenUp()) And $retries < 120)
			Sleep(500)
			$retries = $retries + 1
		WEnd

		Sleep(5000) ;;give the servers a few seconds so we dont instantly fail-to-join

		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)


;~         AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
		_loginfo("Rejoining: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
		_winoutput("Rejoining Game|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "| ")

        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

        $RetryCount = 0
    Do
        If IsGameActive() Then
            HoldStartupGame()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

	if $heavylog Then _loginfo("Failed to rejoin game; exiting")
	_winoutput("Failed to rejoin| | | ")
	Sleep(3000)
	Exit

EndFunc

Func _joinGame()
        VerifyLobbyScreenUp()

		$GameName = $joinGameName
		$GamePass = $joinGamePass

		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y,1,1)
		Sleep(400)

		_winoutput("Joining Game|" & $GameName & "//" & $GamePass & "| |" & $successtotal & "/" & $GameNumber)

        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')

        $RetryCount = 0
    Do
        If IsGameActive() Then
            HoldManualGame()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30

;~ 	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")_wipeentry($windowtitlearray[$i][1]) ;clear data entry and remove from GUI
;~ 	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_winoutput("Hunting again| | |" & $successtotal & "/" & $GameNumber)
	$HoldGame = 0
;~     GUICtrlSetData($HoldAbandonButton, "Hold Game")
	_Main()

EndFunc

; ========================================

Func AntiIdle()

    If IsGameActive() Then
		;; anti-idle with random "vocal" message ("time to die!", etc.)
		_SendMinimized($WindowName, "{NUMPAD" & Random(0, 7, 1) & "}")
	Else
		If Not IsLobbyScreenUp() Then
			;; Give the user a chance to acknowledge the game has been dropped
			Local $sound = _SoundOpen($DroppedSoundFile)
			_SoundPlay($sound)
			_loginfo("Game Dropped!: " & $GameName & "//" & $GamePass & " on " & $CurrentIP)
			_winoutput("Game Dropped!|" & $GameName & "//" & $GamePass & "|" & $CurrentIP & "|" & $successtotal & "/" & $GameNumber)
		EndIf
;~         AppendLineToLogText("Sorry. The game on the hunted IP " & $CurrentIP & " appears to have dropped")
;~ 		GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
;~         $userResponse = MsgBox(32, $VersionInfo & ": Problem", "Game " & $GameName & "//" & $GamePass & " appears to be lost (disconnected?). Check your Diablo II window.")
;~         Exit
    EndIf

EndFunc   ;==>AntiIdle

; ============================================

Func GetLastChatMessage()

    Local $pointer1 = _MemoryRead ($OFFSET_D2MULTI_LAST_CHAT_MSG, $memoryhandle, 'dword')
    Local $pointer2 = _MemoryRead ($pointer1, $memoryhandle, 'dword')
    Local $Temp = _MemoryReadWideString ($pointer2, $memoryhandle, 'ushort[396]')
	If ($oldptr1 == $pointer1) And ($oldptr2 == $pointer2) And ($oldmsg == $Temp) Then
		Return ""
	Else
		$oldptr1 = $pointer1
		$oldptr2 = $pointer2
		$oldmsg = $Temp
		Return $Temp
	EndIf
EndFunc   ;==>GetLastChatMessage

;===============================================================================
;
; Function Name:  _SendMinimized()
;===============================================================================
Func _SendMinimized($Window, $keys)
    ;; note : testing with D2 shows that sending {ENTER} to open the chat screen
    ;;   requires that the D2 window be shown. Otherwise, all other keystrokes
    ;;   seem to be ingored, and the client stays in the chat mode.
	_SendMinimizedMessage($Window,$keys)

EndFunc   ;==>_SendMinimized

;========================================================

Func _ProcessGetLoadedModules($iPID,$dllname)
    Local Const $PROCESS_QUERY_INFORMATION=0x0400
    Local Const $PROCESS_VM_READ=0x0010
    Local $aCall, $hPsapi=DllOpen("Psapi.dll")
    Local $hProcess, $tModulesStruct
    $tModulesStruct=DllStructCreate("hwnd [200]")
    Local $SIZEOFHWND = DllStructGetSize($tModulesStruct)/200
    $hProcess=_WinAPI_OpenProcess(BitOR($PROCESS_QUERY_INFORMATION,$PROCESS_VM_READ),False,$iPID)
    If Not $hProcess Then Return SetError(1,0,-1)
    $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",DllStructGetSize($tModulesStruct),"dword*","")
    If $aCall[4]>DllStructGetSize($tModulesStruct) Then
        $tModulesStruct=DllStructCreate("hwnd ["&$aCall[4]/$SIZEOFHWND&"]")
        $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",$aCall[4],"dword*","")
    EndIf
    Local $aReturn[$aCall[4]/$SIZEOFHWND]
	Local $returnval = 0
    For $i=0 To Ubound($aReturn)-1
        $aCall=DllCall($hPsapi,"dword","GetModuleFileNameExW","ptr",$hProcess,"int",DllStructGetData($tModulesStruct,1,$i+1),"wstr","","dword",65536)
		if (StringRight($aCall[3]	,StringLen($dllname)+1) = "\" & $dllname) Then
;~ 			MsgBox(0,$i,$aCall[3] & @CRLF & DllStructGetData($tModulesStruct,1,$i+1))
			$returnval = DllStructGetData($tModulesStruct,1,$i+1)
		EndIf
        $aReturn[$i]=$aCall[3]
    Next
    _WinAPI_CloseHandle($hProcess)
    DllClose($hPsapi)
    Return $returnval
EndFunc

;;writes entry to a log file
Func _loginfo($message)
	if Not ($message == "") Then
		Local $currentlog = ControlGetText("KCHClient-" & @AutoItPID,"",5)
		if ($currentlog == "") Then
			ControlSetText("KCHClient-" & @AutoItPID,"",5,_Now() & " " & $WindowName & " " & $message)
		Else
			ControlSetText("KCHClient-" & @AutoItPID,"",5,$currentlog & @CRLF & _Now() & " " & $WindowName & " " & $message)
		EndIf
	EndIf
EndFunc

;;get input info from program's window
Func _getwininput()
	Local $input = ControlGetText("KCHClient-" & @AutoItPID,"",3)
	ControlSetText("KCHClient-" & @AutoItPID,"",3,"input")
	if $input = "exit" Then Exit ;input
	if $input = "leave" Then $HoldGame = 0
	if $input = "pause" Then
		if $HuntPaused = 0 Then
			Local $prev = ControlGetText("KCHClient-" & @AutoItPID,"",4)
			_winoutput("Paused" & StringMid($prev,StringInStr($prev,"|")))
			$HuntPaused = 1
		ElseIf $HuntPaused = 1 Then
			$HuntPaused = 0
		EndIf
	EndIf
	if StringLeft($input,5) = "join:" Then
		if StringInStr($input,"/") > 0 Then
		Local $value = StringSplit(StringReplace(StringMid($input,6),"//","/"), "/")
		$joinGameName = $value[1]
		$joinGamePass = $value[2]
		$JoinGame = 1
	Else
		$joinGameName = StringMid($input,6)
		$joinGamePass = ""
		$JoinGame = 1
	EndIf

	EndIf
	if StringLeft($input,6) = "chgip:" Then
		Local $val = 1
		$IPList_old = $IPList
		Do
			$InputIPList = StringMid($input,7)

			$InputIPList = StringStripWS($InputIPList, 8)  ;; strip all spaces
			$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
		Until $SplitIPs[0] >= 1

		;; first element of array after Split is number of returned elements
		ReDim $HuntedIPs [$SplitIPs[0]]
		$IPList = ""

		For $r = 1 To UBound($SplitIPs) - 1
			$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
			If $IPList = "" Then
				$IPList = $SplitIPs[$r]  ;; init to first split IP
			Else
				$IPList = $IPList & ", " & $SplitIPs[$r]
			EndIf

		Next

		$changedip = 1
	EndIf
	if StringLeft($input,6) = "delay:" Then $GameDurationSeconds = StringMid($input,7)
	if (StringLeft($input,10) = "starthold|") And ($startinfo = 0) Then
		Local $string = StringSplit($input,"|")
		$WindowName = $string[2]
		;diablo pid, cuz autoit sucks at getting the pid from a handle as string
		$winprocess = $string[3]
		$heavylog = Int($string[4])
		;start delay
		$startdelay = $string[5]
		$starthold = 1
		$startinfo = 1
	EndIf
	if (StringLeft($input,6) = "start|") And ($startinfo = 0) Then
;~ 		MsgBox(0,"Startup",$input)
		Local $string = StringSplit($input,"|")
		;winhandle info
		$WindowName = $string[2]
		;difficulty info
		if $string[3] = "n" Then
			$LOBBY_CREATE_X = $LOBBY_CREATE_NORM_X
			$LOBBY_CREATE_Y = $LOBBY_CREATE_NORM_Y
		ElseIf $string[3] = "h" Then
			$LOBBY_CREATE_X = $LOBBY_CREATE_HELL_X
			$LOBBY_CREATE_Y = $LOBBY_CREATE_HELL_Y
		EndIf
		;ip info
		$InputIPList = StringStripWS($string[4], 8)  ;; strip all spaces
		$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
		ReDim $HuntedIPs [$SplitIPs[0]]
		$IPList = ""
		For $r = 1 To UBound($SplitIPs) - 1
			$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
			If $IPList = "" Then
				$IPList = $SplitIPs[$r]  ;; init to first split IP
			Else
				$IPList = $IPList & ", " & $SplitIPs[$r]
			EndIf
		Next
		;duration info
		$GameDurationSeconds = $string[5]
		;prefix info
		$UserUniqueGameName = $string[6]
		;pass info
		if Not ($string[7] == "(default)") Then $UserUniqueGamePass = $string[7]
		;diablo pid, cuz autoit sucks at getting the pid from a handle as string
		$winprocess = $string[8]
		;start delay
		$startdelay = $string[9]
		;delaybeforenewgame
		$DelayBeforeNewGameSeconds = $string[10]
		;Sale Interrupt Setting
		$saleopt = $string[11]
		;Set as retrieved start info
		$startinfo = 1
		$stopnum = $string[12]
		$stoptime = ($string[13]*60*1000)
		if Not ($string[14] == -1) Then
			$stopdelay = ($string[14]*60*1000)
		Else
			$stopdelay = -1
		EndIf
		$heavylog = Int($string[15])
	EndIf


;~ 	_winoutput(_NowCalc() & "| | |0/0")
	Sleep(50)
EndFunc

;output info back to parent program
Func _winoutput($message)
	ControlSetText("KCHClient-" & @AutoItPID,"",4,$message)
EndFunc

;called when kchclient closes
Func onexit()
	_MemoryClose($memoryhandle) ;make sure we close the process handle
	_winoutput("Exiting| | | ")
	Sleep(3000)
EndFunc
